	PROCESSOR 16F886
	__CONFIG	_CONFIG1, 020C4h
	__CONFIG	_CONFIG2, _WRT_OFF & _BOR21V
	INCLUDE "P16F886.INC"

;**************************************************
;  
;**************************************************
	CBLOCK 0x20
	TEMP_STATUS		;   STATUS    
	SLAVE        ;   (YYYYxxx0)
	TXBUF        ;  
	RXBUF        ;  
	COUNT        ;  
	ADDR		 ;  
	DATAI        ;     
	DATAO        ;     
	DATAI_1      ;     
	DATAO_1      ;     
	FLAG         ;    
	I2CDEV       ;  
	ERCODE       ;      
	PauzaTemp

	SenReg			; Send data store
	Registr			; Low address store
	WholeDegres		;   
	DecimalDegres	;   
	ConReg			; Control byte store
	Registr1   ;     
	TimerUp ;    1 
	TimerStart  ;     ( )     
	TimerAmpiler ;    
	PowerDownTimer ;         11 -    
	PowerDownTimerLoad ;     PowerDownTimer
	AmpilerT1 ;     
	AccOutTimer ;    ACC      
	ENDC

	W_Temp	equ 0x70		;   W   

	SDA         equ    4   ; RA0 /  SDA
	SCL         equ    3   ; RA1   SCL
	DI          equ    7 ;    I2C
	D0          equ    6 ;   	I2C
	ERR1        equ    0 ; - 	

	#DEFINE ErrPowerDiod PORTB, 0 ;   
	#DEFINE ErrTemperatureDiod PORTB, 1 ;    
	#DEFINE Pechka PORTB, 2 ;   
	#DEFINE AccOut PORTB, 3 ;   
	#DEFINE Ampiler PORTB, 4 ;   



	#DEFINE ErrTemperature Registr1, 0 ;    1-   
	#DEFINE ErrPower Registr1, 1 ;    1-    11 
	#DEFINE StartSystem Registr1, 2 ;      
	#DEFINE AccOutOn Registr1, 3 ;          
	#DEFINE AccInDown Registr1, 4 ;     
	#DEFINE AccUp Registr1, 5 ;     12
	#DEFINE AccInDownSet Registr1, 6 ;    OFF (  )
	#DEFINE AmpilerUp Registr1, 7 ;  

	org 0x000
	goto Start
	ORG 0x004 ; 
	goto Interupt

;**************************************************
; 
;**************************************************
Interupt:
	movwf W_Temp 
	SWAPF STATUS,w
	clrf STATUS
	MOVWF TEMP_STATUS

	btfsc PIR1,ADIF         
	goto IntADC 	;    
	btfsc INTCON,T0IF
	goto IntTMR0 ;     TMR0
	goto ExitInt

IntADC:
;**************************************************
;    
;**************************************************
	bcf PIR1,ADIF
	bcf ErrPower
	movf ADRESH, w
	addlw .0 ;  255-(255)
	addlw .59 ;    (-+1)	255-197+1 
	btfsc STATUS, C
	goto ExitInt
	bsf ErrPower ;   11
	bsf ErrPowerDiod
	bcf AccInDown

	movf ADRESH, w
	addlw .204 ;  255-(51)
	addlw .52 ;    (-+1)	51-0+1 
	btfsc STATUS, C
	bsf AccInDown
	nop ;
	goto ExitInt
	
IntTMR0:
;**************************************************
;    TMR0
;**************************************************
	bcf INTCON,T0IF
	MOVLW .11  
    MOVWF TMR0
	incf TimerUp
	movf TimerUp,w
	sublw .16
	btfsc STATUS,Z
	goto Prer1Sec
	goto ExitInt
Prer1Sec:
;**************************************************
;    TMR0  
;**************************************************
	clrf TimerUp
	bsf ADCON0,GO ;    
	btfss StartSystem
	goto StartAmpiler
	decfsz TimerStart ;       Acc
	goto ExitInt
	bcf StartSystem
	goto ControlBattery
StartAmpiler:
	btfss AccOutOn
	goto ControlBattery
	decfsz TimerAmpiler ;    
	goto ControlBattery
	bcf AccOutOn
ControlBattery:
	btfss AccUp
	goto ExitInt
	btfss ErrPower
	goto PowerGood
	goto PowerNoGood
PowerGood:  ;  
	MOVLW .4  
    MOVWF AccOutTimer
	movf PowerDownTimerLoad, w
	MOVWF PowerDownTimer
	bcf ErrPowerDiod
	btfss AccUp ;         
	goto ExitInt ;    
	bsf AccOut  ;     12 
	btfsc AmpilerUp  ;      
	bsf Ampiler	;   
	bcf AccInDownSet ;    
	goto ExitInt
PowerNoGood: ;   11   
	btfsc AccInDownSet ;        OFF 
	goto ExitInt ;    
	decfsz PowerDownTimer
	goto PowerNoGoodAccDown
	bcf Ampiler ;   11  
	bcf AccOut
	bsf ErrPowerDiod
	bcf AccUp ;       
	movf PowerDownTimerLoad, w
	MOVWF PowerDownTimer
	goto ExitInt
PowerNoGoodAccDown: 
	btfss AccInDown
	goto ExitInt
	decfsz AccOutTimer ;          
	goto ExitInt
	MOVLW .5  
    MOVWF AccOutTimer
	bcf Ampiler ;   Off  
	bcf AccOut
	bsf AccInDownSet
	movf PowerDownTimerLoad, w
	MOVWF PowerDownTimer
	bcf ErrPowerDiod
	goto ExitInt
ExitInt:
	MOVF W_Temp,w
	SWAPF TEMP_STATUS,w
	MOVWF STATUS
	bsf INTCON,GIE
	RETURN ;   
	

;   	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
Start:
;**************************************************
;    
;**************************************************
	clrf SenReg		
	clrf Registr	
	clrf Registr1
	clrf TimerUp
	bsf StartSystem
	MOVLW .3  
    MOVWF TimerStart

	MOVLW .9
	MOVWF PowerDownTimerLoad

	MOVLW .10  
    MOVWF TimerAmpiler

	movf PowerDownTimerLoad, w
	MOVWF PowerDownTimer

	MOVLW .4
    MOVWF AccOutTimer

;**************************************************
;  
;**************************************************
	clrw                    ;  W.
	movwf   PORTB           ; Ensure PORTB is zero before we enable it.
	bsf       STATUS,RP0  
    bsf       STATUS,RP1          ; select Register Bank 3
    movlw     0xFF                ; we want all Port A pins Analog
    movwf     ANSEL
    movlw     0x00
    movwf     ANSELH              ; PortB pins are digitial (important as RB0 is switch)
	bcf       STATUS,RP0          ; back to Register Bank 0
	bcf       STATUS,RP1


	BANKSEL TRISA      ; Select Bank 0
	movlw   0xFF		   ; Set W to mask for all inputs.
	movwf   TRISA	   ; set TRISA register as inputs.
	movlw   b'11100000'
	movwf    TRISB           ;  PORTB
	movlw   b'00011000'
	movwf    TRISC           ;  PORTB
	bcf     STATUS,RP0      ; Select Bank 0
	
;**************************************************
;  
;**************************************************
	bsf STATUS, RP0
	movlw b'00001110' ;   RA0,  
	movwf ADCON1
	bcf STATUS, RP0
	movlw b'10000001'
	movwf ADCON0 ;   Fosc/32,   
	bsf ADCON0,GO ;    
;**************************************************
;  I2
;**************************************************
;	BANKSEL	SSPCON2		;   
;	MOVLW	b'01100000'	; Set ACKSTAT,ACKDT bits
;	MOVWF	SSPCON2		; Reset SEN,ACK bits
;	MOVLW	b'10000000'	;
;	MOVWF	SSPSTAT		; Speed & signal levels
;	MOVLW	0x0C		; Clock = 50kHz	63,13
;	MOVWF	SSPADD		; Load baud rate count-1
;	BANKSEL	SSPCON		; 	
;	MOVLW	b'00101000'	;
;	MOVWF	SSPCON		; Set mode & enable
;	BCF	PIR1,SSPIF	; clear interrupt flag

;**************************************************
;  
;**************************************************
	bsf STATUS, RP0
	movlw b'01100000' ;       TMR0
	movwf INTCON
	movlw b'01000000'  ;    
	movwf PIE1
	bcf STATUS, RP0
	bsf INTCON,GIE		;   
;**************************************************
;   TMR0
;**************************************************
	BANKSEL	OPTION_REG	; 
	MOVLW	B'01000111'	; 
	MOVWF	OPTION_REG	;  1/256
	BANKSEL	TMR0
	MOVLW .11  
    MOVWF TMR0
;**************************************************
;  
;**************************************************


	movlw 0x90		
	movwf SLAVE ;   
	movlw 0xAC	
	movwf ADDR 
	movlw 0x00
	movwf DATAO 
	call WRBYTE


	movlw 0x90		
	movwf SLAVE ;   
	movlw 0xEE	;  
	movwf ADDR 
	call WRCOM


;**************************************************
;  
;**************************************************
	goto SettingLoad
SettingLoadTable
	movfw AmpilerT1
	addwf PCL,f 
	retlw .10
	retlw .20
	retlw .40
	retlw .60
SettingLoad:
	MOVFW PORTB
	ANDLW B'01100000'
	MOVWF AmpilerT1
	rrf AmpilerT1
	rrf AmpilerT1
	rrf AmpilerT1
	rrf AmpilerT1
	rrf AmpilerT1
	call SettingLoadTable
	MOVWF TimerAmpiler
StartSystem_

	btfsc StartSystem ;      
	goto StartSystem_
	btfss ErrPower        ;     
	;goto CheckTemperature_ ;     
	goto GoACC ;    (       )
	bsf ErrPowerDiod ;     
	goto StartSystem_ ;          

CheckTemperature_:
	
	MOVLW .255
	movwf PauzaTemp
	decfsz PauzaTemp
	goto $-1

	bcf ErrPowerDiod ;     
	movlw 0x90		
	movwf SLAVE ;   
	movlw 0xAA	
	movwf ADDR 
	call RDBYTEN
	movf DATAI,w
	MOVWF WholeDegres
	movf DATAI_1,w
	MOVWF DecimalDegres

	call CheckTemperature	
	btfss ErrTemperature
	goto GoACC
	bsf ErrTemperatureDiod  ;   ,  
	bsf Pechka ;   
	GOTO	CheckTemperature_		

GoACC:
	bcf ErrTemperatureDiod  ;   ,  
	bcf Pechka ;   
	bsf AccOut ;    
	bsf AccUp ;    
	bsf AccOutOn ;      
AmpilerUp_:
	btfsc AccOutOn ;   
	goto AmpilerUp_
	bsf Ampiler ;  
	bsf AmpilerUp ;    
ControlBatteryOnly:
	goto ControlBatteryOnly



;**************************************************
; 
;**************************************************
;  I2C

;    SSPIF /
wint
	bcf INTCON,GIE		
	BANKSEL	PIR1 		;   
	BCF	PIR1,SSPIF	;   
win	
	NOP
	BTFSS	PIR1,SSPIF	; .. 
	GOTO	win		; .. /
	bsf INTCON,GIE
	RETURN			; 


;   ....................................	
send
	NOP			 
	BANKSEL	SSPBUF		;   
	MOVWF	SSPBUF		;  address/data
	CALL	wint		;   
	RETURN			; 

;   START
sencon	
	NOP			
	BANKSEL	PIR1
	BCF	PIR1,SSPIF	;   
	BANKSEL SSPCON2	;   
	BSF	SSPCON2,ACKSTAT ;   ACKSTAT
	BSF	SSPCON2,SEN	;   START
	CALL	wint		;    START
	MOVF	ConReg,W	; SEND CONTROL BYTE
	CALL	send		;   
	RETURN			; 

; 
senadd	
	NOP
	BANKSEL SSPCON		;   
	MOVF	Registr,W		;  
	CALL	send		; 
	RETURN ; 

; 
sendat	
	MOVF	SenReg,W	;  
	CALL	send		; 
	RETURN			; 	

;   STOP
senstop	
	NOP
	BANKSEL	SSPCON2		;   
	BSF	SSPCON2,PEN	;   STOP
	CALL	wint		; 
	RETURN			; 

;  
senack
	NOP
	BANKSEL	SSPCON2  ;   
	BSF	SSPCON2,ACKDT	;   ack
	BSF	SSPCON2,ACKEN	; 
	CALL	wint		; 
	RETURN			; 

; 
senack_	
	NOP
	BANKSEL	SSPCON2
	BCF	SSPCON2,ACKDT	;   ack
	BSF	SSPCON2,ACKEN	;  
	CALL	wint		; 
	RETURN			; 




;       ...................
readb
	MOVLW	0x90		; Control byte to WRITE
	MOVWF	ConReg		; address to memory
	CALL	sencon		; Send control byte
	CALL	senadd		; Send address bytes
	CALL	senstop		; Stop
	MOVLW	0x91		; Control byte to READ
	MOVWF	ConReg		; data from memory
	CALL	sencon		; Send control byte
	BANKSEL	SSPCON2
	BSF	SSPCON2,RCEN	; Enable receive mode
war	BTFSS	SSPSTAT,BF	; Check ...
	GOTO	war		; for read done
	CALL	senack_		; send NOT acknowledge
	MOVF	SSPBUF,W	; Read receive buffer
	MOVWF	WholeDegres		; and store it
	BANKSEL	SSPCON2
	BSF	SSPCON2,RCEN	; Enable receive mode
war1
	BTFSS	SSPSTAT,BF	; Check ...
	GOTO	war1		; for read done
	CALL	senack		; send NOT acknowledge
	CALL	senstop		; send stop bit
	MOVF	SSPBUF,W	; Read receive buffer
	MOVWF	DecimalDegres		; and store it
	RETURN	

; 
CheckTemperature
	btfsc WholeDegres, 7
	goto SetErrTemperature
	bcf ErrTemperature
	goto ExitCheckTemperature
SetErrTemperature:
	bsf ErrTemperature
ExitCheckTemperature:
	Return






WaitTX
    bsf STATUS,RP0 ;  1
    btfss TXSTA,TRMT ;    ( 0)
    goto $-1
    bcf STATUS,RP0 ;  0
    return
;***************************************************
;       I2C
;***************************************************
WRBYTE:
	movf SLAVE,w ;   
	movwf TXBUF ;   
	call BSTART ;   START
	call TX ;   
	movf ADDR,w ;   
	movwf TXBUF ;   
	call TX ;   
	movf DATAO,w ;  
	movwf TXBUF ;   
	call TX ;  
	call BSTOP ;   STOP
	return
;***************************************************
;     I2C
;***************************************************
WRCOM:
	movf SLAVE,w
	movwf TXBUF
	call BSTART
	call TX
	movf ADDR,w
	movwf TXBUF
	call TX
	call BSTOP
	return
;***************************************************
;       I2C
;***************************************************
WRBYTEN:
	movf SLAVE,w
	movwf TXBUF
	call BSTART
	call TX
	movf ADDR,w
	movwf TXBUF
	call TX
	movf DATAO,w
	movwf TXBUF
	call TX
	movf DATAO_1,w
	movwf TXBUF
	call TX
	call BSTOP
	return
;***************************************************
;      I2C
;***************************************************
RDBYTE:
	movf SLAVE,w
	movwf TXBUF
	call BSTART
	call TX
	movf ADDR,w
	movwf TXBUF
	call TX
	call BSTART
	movf SLAVE,w
	movwf TXBUF
	bsf TXBUF,0
	call TX
	call RX
	call BSTOP
	movf RXBUF,w
	movwf DATAI
	return
;***************************************************
;       I2C
;***************************************************
RDBYTEN
	movf SLAVE,w
	movwf TXBUF
	call BSTART
	call TX
	movf ADDR,w
	movwf TXBUF
	call TX
	call BSTART
	movf SLAVE,w
	movwf TXBUF
	bsf TXBUF,0
	call TX
	call RX0
	movf RXBUF,w
	movwf DATAI
	call RX
	movf RXBUF,w
	movwf DATAI_1
	call BSTOP
	return
;***************************************************
;   
;***************************************************
BSTART:
	bcf STATUS,RP1
	bsf STATUS,RP0
	bcf	TRISC,SDA
	bsf	TRISC,SCL
	bcf	STATUS,RP0
	bsf PORTC,SDA
	movlw .1
	btfss PORTC,SCL
	call ERR
	BCF PORTC,SDA
	nop
	nop
	nop
	bcf PORTC,SCL
	retlw 0
;**************************************************
;   
;**************************************************
BSTOP:
	bcf PORTC,SDA
	bcf       STATUS,RP1
	bsf       STATUS,RP0
	bcf	TRISC,SDA
	bsf	TRISC,SCL
	bcf	STATUS,RP0
	nop
	nop
	nop
	nop
	nop
	bsf STATUS,RP0
	bsf	TRISC,SDA
	bcf	STATUS,RP0
	movlw .1
	btfss PORTC,SCL
	call ERR
	movlw .4
	btfss PORTC,SDA
	call ERR
	retlw 0
;**************************************************
;      I2C
;**************************************************
BITIN:
	bcf STATUS,RP1
	bsf STATUS,RP0
	bsf TRISC,SCL
	bsf TRISC,SDA
	bcf	STATUS,RP0
	bcf I2CDEV,DI
	movlw .1
	btfsc PORTC,SCL
	goto BIT1
	btfss FLAG,ERR1
	movwf ERCODE
	bsf FLAG,ERR1
BIT1:
	bcf PORTC,SDA
	bsf STATUS,RP0
	bsf TRISC,SCL
	bsf TRISC,SDA
	bcf	STATUS,RP0
	nop
	nop
	nop
	nop
	nop
	btfsc PORTC,SDA
	bsf I2CDEV,DI
	nop
	nop
	bcf	PORTC,SCL
	bsf STATUS,RP0
	bcf TRISC,SCL
	bsf TRISC,SDA
	bcf	STATUS,RP0
	retlw 0
;************************************************
;      I2C
;************************************************
BITOUT:
	bcf STATUS,RP1
	bsf STATUS,RP0
	bcf TRISC,SCL
	bsf TRISC,SDA
	bcf	STATUS,RP0
	btfss I2CDEV,D0
	goto BIT0
	bsf PORTC,SDA
	movlw .2
	btfsc PORTC,SDA
	goto CLK1
	btfss FLAG,ERR1
	movwf ERCODE
	bsf FLAG,ERR1
	goto CLK1
BIT0:
	bsf STATUS,RP0
	bcf TRISC,SDA
	bcf	STATUS,RP0
	bcf PORTC,SDA
	nop
	nop
	nop
	nop
	nop
CLK1:
	bsf STATUS,RP0
	bsf TRISC,SCL
	bcf	STATUS,RP0
	movlw .1
	btfsc PORTC,SCL
	goto BIT2
	btfss FLAG,ERR1
	movwf ERCODE
	bsf FLAG,ERR1
BIT2:
	nop
	nop
	nop
	bcf	PORTC,SCL
	bsf STATUS,RP0
	bcf TRISC,SCL
	bsf TRISC,SDA
	bcf STATUS,RP0
	retlw 0
;**************************************************
;  8-    I2C
;**************************************************
RX:
	movlw .8
	movwf COUNT
	clrf RXBUF
RXLP:
	rlf RXBUF,f
	skpc
	bcf RXBUF,0
	skpnc
	bsf RXBUF,0
	call BITIN
	btfsc I2CDEV,DI
	bsf RXBUF,0
	decfsz COUNT,f
	goto RXLP
	bsf I2CDEV,D0
	call BITOUT
	retlw 0
;**************************************************
;  8-    I2C
;**************************************************
RX0:
	movlw .8
	movwf COUNT
	clrf RXBUF
RXLP0:
	rlf RXBUF,f
	skpc
	bcf RXBUF,0
	skpnc
	bsf RXBUF,0
	call BITIN
	btfsc I2CDEV,DI
	bsf RXBUF,0
	decfsz COUNT,f
	goto RXLP0
	bcf I2CDEV,D0
	call BITOUT
	retlw 0
;**************************************************
;     I2C 
;**************************************************
TX:
	movlw .8
	movwf COUNT
TXLP:
	bcf I2CDEV,D0
	btfsc TXBUF,7
	bsf I2CDEV,D0
	call BITOUT
	rlf TXBUF,f
	skpc
	bcf TXBUF,0
	skpnc
	bsf TXBUF,0
	decfsz COUNT,f
	goto TXLP
	call BIT1
	movlw .3
	btfsc I2CDEV,DI
	call ERR
	retlw 0
;***********************************************
;      I2C
;***********************************************
ERR:
	btfss FLAG,ERR1
	movwf ERCODE
	bsf FLAG,ERR1
	retlw 0
	END	
